/*-----------------------------------------------------------------------*
 * filename - epocerr.c
 *
 * function(s)
 *        _ErrorExit    - Display error in message box then exit.
 *-----------------------------------------------------------------------*/

/*
 *      C/C++ Run Time Library - Version 11.0
 *
 *      Copyright (c) 2002, 2004 by Borland Software Corporation
 *      All Rights Reserved.
 *
 */

/* $Revision: 1.1 $        */

#include <windows.h>

/*-----------------------------------------------------------------------*

Name            _ErrorExit - print an error message to console

Usage           void _ErrorExit(const char *s);

Prototype in    _io.h

Description     _ErrorExit writes the specified string to the
                console device.  If the program is running on
                a windowing system, a pop-up message box is displayed.
                Otherwise, the message is displayed on the screen,
                preceded and followed by newlines.

Return value    None.

*------------------------------------------------------------------------*/

void _EXPFUNC _ErrorExit(const char *s)
{
	MessageBox(NULL,"Error:",s,MB_OK);
	ExitProcess(1);
}
